#include <bits/stdc++.h>

#define ll unsigned long long
#define pb push_back
#define MAXN 200010

using namespace std;

vector<int> tree[MAXN];
ll down[MAXN], up[MAXN];
ll sum_down[MAXN], sum_up[MAXN], arr[MAXN];

void dfs_down(int u, int p) {

    down[u] = 0;
    sum_down[u] = arr[u];
    for(int v: tree[u]) {
        if(v != p) {
            dfs_down(v, u);
            down[u] += down[v] + sum_down[v];
            sum_down[u] += sum_down[v];
        }
    }
}

void dfs_up(int u, int p) {

    up[u] = 0;
    sum_up[u] = arr[u];
    if(p != -1) {
        sum_up[u] = sum_up[p] + (sum_down[p] - sum_down[u]) - arr[p] + arr[u];
        up[u] = sum_up[u] - arr[u] + up[p] + down[p] - down[u] - sum_down[u];
    }
    for(int v: tree[u])
        if(v != p)
            dfs_up(v, u);
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n;
    cin >> n;

    for(int i = 0; i < n - 1; i++) {
        int u, v;
        cin >> u >> v;
        u--; v--;

        tree[u].pb(v);
        tree[v].pb(u);
    }
    for(int i = 0; i < n; i++)
        cin >> arr[i];

    int q;
    cin >> q;

    dfs_down(0, -1);
    dfs_up(0, -1);

    int ans = 0;
    ll mn = up[0] + down[0];
    for(int i = 0; i < n; i++) {
        if(up[i] + down[i] < mn) {
            mn = up[i] + down[i];
            ans = i;
        }
    }
    cout << ans + 1 << endl;
    return 0;
}